#include <stdio.h>
#include <windows.h>

#include "record.h"
#include "extern.h"



/*
8-bit ADPCM  (v1)
- Gabriel Knight  (22050 speech)
- King's Quest V  (----- speech)
- King's Quest VI  (----- speech)


8-bit ADPCM  (v2)
- Freddy Pharkas  (----- speech)
- Torin's Passage  (11025 / 22050 sfx)


16-bit ADPCM
- King's Quest VII  (22050 speech)
- Leisure Suit Larry 6  (22050 speech)
- Police Quest IV  (11025 speech)
- Police Quest: SWAT  (----- speech)
- Quest for Glory IV  (11025 speech)
- Space Quest VI  (----- speech)
- Torin's Passage  (22050 speech)
*/




FILE *fp, *fp_log;

UINT8 buf[0x800000];
UINT8 buf_old[0x800000];
INT16 pcm[0x800000];
INT16 pcm1[0x800000];
INT16 pcm2[0x800000];


INT32 dpcm_l, dpcm_r;
INT32 dpcm_ver;

INT32 bit4, wave_num;
INT32 overflow_count, noise_count;



AUDHeader header;
UINT8 stereo, use16;
UINT32 start;


BOOL overflow, newline;
INT error_found;

BOOL fix_clip, fix_noise;
BOOL check_clip, check_noise;
BOOL write_file, dump_file, find_file;
BOOL fix_clip_once;


INT start_file, stop_file;





void Scan_AUD_Resource()
{
	static int TEST = 0;


	if( TEST )
	{
		start = 0xFE140EB;
		TEST = 0;
	}
	else
		start = ftell(fp);



	// set read mode
	fseek( fp, start, SEEK_SET );
	fread( &header, 1, sizeof(AUDHeader), fp );
	if( feof(fp) ) return;



	// not valid
	if( strcmp( header.szID, "SOL\0" ) != 0 )
	{
		fseek( fp, ftell(fp) - sizeof(AUDHeader) + 1, SEEK_SET );
		return;
	}


	// #########################################################
	// #########################################################
	// #########################################################

	wave_num++;



	// read dummy
	fread( &buf, 1, (header.bShift+2) - sizeof(AUDHeader), fp );


	// grab data
	if( find_file == TRUE && (UINT) start_file == start )
	{
		fread( &buf, 1, header.dwDataSize, fp );
		if( feof(fp) ) return;


		// save copy
		memcpy( &buf_old, &buf, header.dwDataSize );
	}

	else if( wave_num >= start_file && wave_num <= stop_file )
	{
		fread( &buf, 1, header.dwDataSize, fp );
		if( feof(fp) ) return;


		// save copy
		memcpy( &buf_old, &buf, header.dwDataSize );
	}

	// skip file
	else
	{
		fseek( fp, header.dwDataSize, SEEK_CUR );
		return;
	}


	// ####################################################
	// ####################################################
	// ####################################################

	// raw file
	if( ( header.bFlags & 0x01 ) == 0 )
		return;


	// format
	stereo = 0;
	use16 = header.bFlags & 0x04;


	// 8-bit unsigned
	if( use16 == 0 )
	{
		dpcm_l = 0x80;
		dpcm_r = 0x80;
	}

	// 16-bit signed
	else
	{
		dpcm_l = 0;
		dpcm_r = 0;
	}


	// ####################################################
	// ####################################################
	// ####################################################

	fix_clip = FALSE;
	fix_noise = FALSE;



	Decode();


	if( check_noise == TRUE )
		Check_Noise();


	Report_Limit();


	// ####################################################
	// ####################################################
	// ####################################################

	// rewrite new data back to file
	if( write_file )
	{
		fseek( fp, start + (header.bShift+2), SEEK_SET );
		fwrite( &buf, 1, header.dwDataSize, fp );
	}


	// ####################################################
	// ####################################################
	// ####################################################

	FILE *fp_dump, *fp_old;
	char str[256];



	if( dump_file == FALSE )
		return;


	// only dump clip errors
	if( check_clip == TRUE && fix_clip_once == FALSE )
		return;


	// not pure dump mode only
	if( check_noise == TRUE )
		return;





	sprintf( str, "@%07X.001", wave_num );
	fp_old = fopen( str, "wb" );
	if( fp_old )
	{
		fwrite( &header, 1, (header.bShift+2), fp_old );
		fwrite( &buf_old, 1, header.dwDataSize, fp_old );
		fclose( fp_old );
	}



	sprintf( str, "@%07X.002", wave_num );
	fp_dump = fopen( str, "wb" );
	if( fp_dump )
	{
		fwrite( &header, 1, (header.bShift+2), fp_dump );
		fwrite( &buf, 1, header.dwDataSize, fp_dump );
		fclose( fp_dump );
	}




	sprintf( str, "@%07X-0.wav", wave_num );
	RecordStart( str, header.wSampleRate, 16, 1 );
	RecordBuffer( (BYTE *) pcm, header.dwDataSize * ( 16 / 8 ) );
	RecordStop();



	return;
	/*
	Interp1_16();
	sprintf( str, "@%07X-1.wav", wave_num );
	RecordStart( str, header.wSampleRate, 16, 1 );
	RecordBuffer( (BYTE *) pcm1, header.dwDataSize * ( 16 / 8 ) );
	RecordStop();


	Interp2_16();
	sprintf( str, "@%07X-2.wav", wave_num );
	RecordStart( str, header.wSampleRate * 2, 16, 1 );
	RecordBuffer( (BYTE *) pcm2, header.dwDataSize * ( 16 / 8 ) * 2 );
	RecordStop();
	*/
}



void main( int argc, char **argv )
{
	if( argc < 5 )
		return;


	error_found = 0;
	write_file = FALSE;




	sscanf( argv[1], "%d", &dpcm_ver );
	sscanf( argv[3], "%d", &start_file );
	sscanf( argv[4], "%d", &stop_file );



	if( argc >= 6 )
	{
		if( strcmp( argv[5], "dump" ) == 0 )
			dump_file = TRUE;

		if( strcmp( argv[5], "dump_find" ) == 0 )
		{
			dump_file = TRUE;
			find_file = TRUE;
		}

		else if( strcmp( argv[5], "clip" ) == 0 )
		{
			dump_file = TRUE;
			check_clip = TRUE;
		}

		else if( strcmp( argv[5], "final_clip" ) == 0 )
		{
			check_clip = TRUE;
			write_file = TRUE;
		}

		else if( strcmp( argv[5], "noise" ) == 0 )
			check_noise = TRUE;

		else if( strcmp( argv[5], "final_noise" ) == 0 )
		{
			check_noise = TRUE;
			write_file = TRUE;
		}
	}



	if( write_file == TRUE )
		fp = fopen( argv[2], "rb+" );
	else
		fp = fopen( argv[2], "rb" );



	if( !fp ) return;


	fp_log = fopen( "log.txt", "w" );


	// ###################################################
	// ###################################################
	// ###################################################

	while( !feof(fp) )
	{
		Scan_AUD_Resource();


		if( error_found >= 30 )
			break;
	}


	fprintf( fp_log, "\n" );
	fprintf( fp_log, "\n" );
	fprintf( fp_log, "Total audio = %d\n", wave_num );


	if( error_found )
		fprintf( fp_log, "- Check file for errors  (%d left)\n", error_found );



	fclose( fp );
	fclose( fp_log );
}
